# 🏢 Empreendedor MEI - Sistema de Regularização DAS

Sistema web para consulta de CNPJ, visualização de débitos DAS e pagamento via PIX para Microempreendedores Individuais (MEI).

## 🚀 Início Rápido

### Pré-requisitos
- XAMPP instalado (Apache + PHP)
- Navegador web moderno
- Conexão com internet

### Instalação

1. **Clone ou baixe o projeto** para:
   ```
   C:\xampp\htdocs\empreendedormei
   ```

2. **Inicie o Apache** no XAMPP Control Panel

3. **Acesse no navegador**:
   ```
   http://localhost/empreendedormei/a.php
   ```

## 📚 Documentação

- **[📋 Análise Completa do Projeto](./ANALISE_PROJETO.md)** - Análise detalhada da estrutura, tecnologias e funcionalidades
- **[🚀 Guia de Hospedagem Localhost](./GUIA_LOCALHOST.md)** - Instruções passo a passo para configurar e executar localmente

## 🛠️ Tecnologias

- **Frontend**: Vue.js 3, Tailwind CSS, HTML5
- **Backend**: PHP 7.4+
- **APIs**: OpenCNPJ (consulta CNPJ - 100 req/min), PayFort PIX (pagamentos)

## 📁 Estrutura do Projeto

```
empreendedormei/
├── a.php                 # Página inicial (consulta CNPJ)
├── minha-conta.php       # Página da conta do usuário
├── debitos.html          # Lista de débitos DAS
├── aviso-pagamento.html  # Aviso legal
├── loading.html          # Tela de carregamento
├── fatura.html           # Pagamento PIX
├── api/                  # APIs de pagamento
├── components/           # Componentes Vue.js
├── css/                  # Estilos customizados
└── assets/               # Imagens e recursos
```

## 🔄 Fluxo Principal

1. **Consulta CNPJ** → `a.php?cnpj=12345678000190`
2. **Visualiza Status MEI** → `minha-conta.php`
3. **Lista Débitos** → `debitos.html`
4. **Aviso de Pagamento** → `aviso-pagamento.html`
5. **Gera PIX** → `loading.html`
6. **Pagamento** → `fatura.html` (QR Code PIX)

## ⚠️ Importante

- **APIs de Pagamento**: Atualmente retornam dados mockados. Para produção, é necessário integrar com uma API de pagamento real.
- **Dados de Débitos**: Estão hardcoded no código. Em produção, devem vir de uma base de dados ou API.
- **Autenticação**: Simplificada via localStorage. Não há sistema de sessão server-side.

## 🔒 Segurança

⚠️ Este é um projeto de **desenvolvimento**. Para produção, implemente:
- Autenticação server-side com sessões
- Validação e sanitização de inputs
- HTTPS
- Proteção CSRF
- Rate limiting

## 📝 Licença

Este projeto é de uso interno/desenvolvimento.

---

**Versão**: 1.0.0  
**Última atualização**: Janeiro 2025

